clear
set more off
graph drop _all
use morg_cleaned_1985.dta, clear
foreach yr of numlist 1986/2012 {
append using morg_cleaned_`yr'.dta 
}
assert schenr!=. & ageg!=.
tempfile temp

save `temp', replace

gen age=1 if ageg==1
replace age=2 if ageg==2 | ageg==3
rename schenr enroll
gen lfpr=(empstat==1 | empstat==2)*finwgt
gen lfpr_enroll=lfpr if enroll==1
gen lfpr_noenroll=lfpr if enroll==0

replace enroll=enroll*finwgt
gen noenroll=(enroll==0)*finwgt

sort year ageg
collapse (sum) lfpr lfpr_enroll lfpr_noenroll enroll noenroll finwgt, by(year ageg)
replace lfpr=lfpr*100/finwgt
replace lfpr_enroll=lfpr_enroll*100/enroll
replace lfpr_noenroll=lfpr_noenroll*100/noenroll
replace enroll=enroll*100/finwgt

# delimit ;

twoway 
	(connected enroll year if ageg==1 , msymbol(circle) msize(medsmall) mcolor(maroon) lcolor(maroon) lwidth(thin) lpattern(dashsolid))
	(connected lfpr_enroll year if ageg==1 , msymbol(triangle_hollow) msize(medsmall) mcolor(navy) lcolor(navy) lwidth(thin) lpattern(solid))
	(connected lfpr_noenroll year if ageg==1 , msymbol(square_hollow) msize(medsmall) mcolor(navy) lcolor(navy) lwidth(thin) lpattern(solid)),
	xtitle("", size(small))
	ytitle("Share", size(vsmall))
	ylabel(20(20)100,labsize(vsmall) nogrid)
	ymlabel(20(10)100, nolabels nogrid)
	xlabel(1985 1990 1995 2000 2005 2010, labsize(vsmall))
	xmlabel(1985(1)2013, nolabels)
	graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) 
	plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
	legend(order(1 "Enrollment rate" 2 "Participation rate, enrolled" 3 "Participation rate, not enrolled") size(vsmall) rows(1))
	title("", size(small))
	name(lfpr_1618, replace)
	saving("lfpr-enroll-1618.gph", replace);

twoway 
	(connected enroll year if ageg==2 , msymbol(circle) msize(medsmall) mcolor(maroon) lcolor(maroon) lwidth(thin) lpattern(dashsolid))
	(connected lfpr_enroll year if ageg==2 , msymbol(triangle_hollow) msize(medsmall) mcolor(navy) lcolor(navy) lwidth(thin) lpattern(solid))
	(connected lfpr_noenroll year if ageg==2 , msymbol(square_hollow) msize(medsmall) mcolor(navy) lcolor(navy) lwidth(thin) lpattern(solid)),
	xtitle("", size(small))
	ytitle("Share", size(vsmall))
	ylabel(20(20)100,labsize(vsmall) nogrid)
	ymlabel(20(10)100, nolabels nogrid)
	xlabel(1985 1990 1995 2000 2005 2010, labsize(vsmall))
	xmlabel(1985(1)2013, nolabels)
	graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) 
	plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
	legend(order(1 "Enrollment rate" 2 "Participation rate, enrolled" 3 "Participation rate, not enrolled") size(vsmall) rows(1))
	title("", size(small))
	name(lfpr_1924, replace)
	saving("lfpr-enroll-1924.gph", replace);


